---
generated_at: 2026-01-27 11:05:00
metrics:
  claims_total: 23
  claims_with_evidence: 22
  claims_without_evidence: 1
confidence_derived: 0.96
---

# 根拠レポート：8-Notebook Cell Output Copy

## 本レポートについて

### 目的
本レポートは、生成された設計書・ドキュメントの信頼性を検証し、人間レビュアーが効率的にレビューできるようにすることを目的としています。

### チェック方法
以下の観点でドキュメントの内容（Claim：主張）を検証しています：

1. **根拠の有無確認**：各主張に対して、ソースコード・既存設計書・要件定義書などの根拠（Evidence）が存在するか
2. **根拠との整合性**：主張の内容が根拠と矛盾していないか
3. **網羅性**：参照すべき情報源を適切にカバーしているか

### 信頼度スコアの算出
- **confidence_derived** = 根拠あり件数 / 総主張件数
- 状態「○」：根拠あり、「△」：根拠不足または要確認

### 本レポートの使い方
1. まず「サマリー」で全体の信頼度と優先レビュー項目を確認
2. 「Claims と根拠の対応」で △ の項目を重点的にレビュー
3. 「不足情報」で補完が必要な情報源を確認

---

## 1) サマリー（まず見るところ）
- 総合信頼度（derived）：**0.96**
  - 根拠あり：22 / 23、根拠なし：1
- 優先レビュー（高）
  1. **目標コピー/保存時間**：明示的な定義なし

## 2) 参照した情報（Evidence一覧）

- E-01: `src/vs/workbench/contrib/notebook/browser/controller/cellOutputActions.ts` - COPY_OUTPUT_COMMAND_ID (行26)
- E-02: `src/vs/workbench/contrib/notebook/browser/controller/cellOutputActions.ts` - CopyCellOutputAction (行56-96)
- E-03: `src/vs/workbench/contrib/notebook/browser/controller/cellOutputActions.ts` - SAVE_OUTPUT_IMAGE_COMMAND_ID (行182)
- E-04: `src/vs/workbench/contrib/notebook/browser/controller/cellOutputActions.ts` - SaveCellOutputImageAction (行184-267)
- E-05: `src/vs/workbench/contrib/notebook/browser/controller/cellOutputActions.ts` - mimeToExt mapping (行229-240)
- E-06: `src/vs/workbench/contrib/notebook/browser/controller/cellOutputActions.ts` - showSaveDialog (行247-253)
- E-07: `src/vs/workbench/contrib/notebook/browser/controller/cellOutputActions.ts` - fileService.writeFile (行259-262)
- E-08: `src/vs/workbench/contrib/notebook/browser/controller/cellOutputActions.ts` - getOutputViewModelFromContext (行120-146)
- E-09: `src/vs/workbench/contrib/notebook/browser/controller/cellOutputActions.ts` - 画像コピー処理 (行87-90)
- E-10: `src/vs/workbench/contrib/notebook/browser/controller/cellOutputActions.ts` - テキストコピー処理 (行92)

## 3) Claims と根拠の対応（レビューの主戦場）
| Claim ID | 主張 | Evidence | 状態 |
|---|---|---|---|
| C-01 | コピーコマンドIDはnotebook.cellOutput.copy | E-01 | ○ |
| C-02 | 保存コマンドIDはnotebook.cellOutput.saveImage | E-03 | ○ |
| C-03 | CopyCellOutputActionでコピー処理 | E-02 | ○ |
| C-04 | SaveCellOutputImageActionで画像保存 | E-04 | ○ |
| C-05 | image/*開始でcopyOutputImage | E-09 (行87) | ○ |
| C-06 | それ以外でcopyCellOutput | E-10 (行92) | ○ |
| C-07 | mimeToExtで拡張子決定 | E-05 | ○ |
| C-08 | image/png -> .png | E-05 (行230) | ○ |
| C-09 | image/jpeg -> .jpg | E-05 (行231-232) | ○ |
| C-10 | image/gif -> .gif | E-05 (行233) | ○ |
| C-11 | image/svg+xml -> .svg | E-05 (行234) | ○ |
| C-12 | image/webp -> .webp | E-05 (行235) | ○ |
| C-13 | image/bmp -> .bmp | E-05 (行236) | ○ |
| C-14 | image/tiff -> .tiff | E-05 (行237) | ○ |
| C-15 | デフォルトファイル名はimage.{ext} | E-04 (行241) | ○ |
| C-16 | showSaveDialogでファイル選択 | E-06 | ○ |
| C-17 | fileService.writeFileで保存 | E-07 | ○ |
| C-18 | 保存失敗時にlogService.error | E-07 (行264) | ○ |
| C-19 | 保存成功時にlogService.info | E-07 (行262) | ○ |
| C-20 | getOutputViewModelFromContextで出力取得 | E-08 | ○ |
| C-21 | focusNotebookCellで画像コピー前にフォーカス | E-09 (行88-89) | ○ |
| C-22 | MIME Type不一致で処理終了 | E-04 (行218-220) | ○ |
| C-23 | 目標コピー/保存時間 | **根拠なし** | △ |

## 4) 不足情報（Unknown / Missing）
- パフォーマンス要件（目標コピー/保存時間）は実装コードに明示的な定義がない
  - 候補：パフォーマンステスト仕様書 / 非機能要件定義書

## 5) リスクフラグ（レビュー観点）
- 0: 低リスク - コマンドID定義（E-01, E-03に基づく）
- 0: 低リスク - MIME Type対応（E-05に基づく）
- 0: 低リスク - 保存処理フロー（E-06, E-07に基づく）
- 1: 中リスク - パフォーマンス要件（推測に基づく記述）

## 6) レビュアーチェックリスト（最小）
- [ ] コマンドIDが最新実装と一致しているか
- [ ] mimeToExtのマッピングが完全か
- [ ] 画像コピー時のfocusNotebookCell処理が正しいか
- [ ] エラーケースの対応が実装と一致しているか
- [ ] メニュー表示条件（when句）が正しいか
